/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import dan200.computercraft.shared.config.ConfigFile;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class ForgeConfigFile
extends ConfigFile {
    private final ModConfigSpec spec;

    private ForgeConfigFile(ModConfigSpec spec, Map<String, ConfigFile.Entry> entries) {
        super(entries);
        this.spec = spec;
    }

    public ModConfigSpec spec() {
        return this.spec;
    }

    private static final class ValueImpl<T>
    extends ConfigFile.Value<T> {
        private final ModConfigSpec.ConfigValue<T> value;

        private ValueImpl(String path, String comment, ModConfigSpec.ConfigValue<T> value) {
            super(path, comment);
            this.value = value;
        }

        @Override
        public T get() {
            return (T)this.value.get();
        }
    }

    static class Builder
    extends ConfigFile.Builder {
        private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();

        Builder() {
        }

        private void translation(String name) {
            this.builder.translation(this.getTranslation(name));
        }

        @Override
        public ConfigFile.Builder comment(String comment) {
            super.comment(comment);
            this.builder.comment(comment);
            return this;
        }

        @Override
        public void push(String name) {
            super.push(name);
            this.translation(name);
            this.builder.push(name);
        }

        @Override
        public void pop() {
            super.pop();
            this.builder.pop();
        }

        @Override
        public ConfigFile.Builder worldRestart() {
            this.builder.worldRestart();
            return this;
        }

        private <T> ConfigFile.Value<T> defineValue(String name, ModConfigSpec.ConfigValue<T> value) {
            ValueImpl<T> wrapped = new ValueImpl<T>(this.getPath(name), this.takeComment(), value);
            ((ConfigFile.Builder.RootGroup)this.groupStack.getLast()).children().put(name, wrapped);
            return wrapped;
        }

        @Override
        public <T> ConfigFile.Value<T> define(String name, T defaultValue) {
            this.translation(name);
            return this.defineValue(name, this.builder.define(name, defaultValue));
        }

        @Override
        public ConfigFile.Value<Boolean> define(String name, boolean defaultValue) {
            this.translation(name);
            return this.defineValue(name, (ModConfigSpec.ConfigValue)this.builder.define(name, defaultValue));
        }

        @Override
        public ConfigFile.Value<Integer> defineInRange(String name, int defaultValue, int min, int max) {
            this.translation(name);
            return this.defineValue(name, (ModConfigSpec.ConfigValue)this.builder.defineInRange(name, defaultValue, min, max));
        }

        @Override
        public <T> ConfigFile.Value<List<? extends T>> defineList(String name, List<? extends T> defaultValue, Supplier<T> newValue, Predicate<Object> elementValidator) {
            this.translation(name);
            return this.defineValue(name, this.builder.defineList(name, defaultValue, newValue, elementValidator));
        }

        @Override
        public <V extends Enum<V>> ConfigFile.Value<V> defineEnum(String name, V defaultValue) {
            this.translation(name);
            return this.defineValue(name, (ModConfigSpec.ConfigValue)this.builder.defineEnum(name, defaultValue));
        }

        @Override
        public ConfigFile build(ConfigFile.ConfigListener onChange) {
            Map<String, ConfigFile.Entry> children = ((ConfigFile.Builder.RootGroup)this.groupStack.removeLast()).children();
            if (!this.groupStack.isEmpty()) {
                throw new IllegalStateException("Mismatched config push/pop");
            }
            ModConfigSpec spec = this.builder.build();
            return new ForgeConfigFile(spec, children);
        }
    }
}

