/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.builder;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.command.text.ChatHelpers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jspecify.annotations.Nullable;

public final class HelpingArgumentBuilder
extends LiteralArgumentBuilder<CommandSourceStack> {
    private final Collection<HelpingArgumentBuilder> children = new ArrayList<HelpingArgumentBuilder>();
    private @Nullable Predicate<CommandSourceStack> requirement;
    private static final ChatFormatting HEADER = ChatFormatting.LIGHT_PURPLE;
    private static final ChatFormatting SYNOPSIS = ChatFormatting.AQUA;
    private static final ChatFormatting NAME = ChatFormatting.GREEN;

    private HelpingArgumentBuilder(String literal) {
        super(literal);
    }

    public static HelpingArgumentBuilder choice(String literal) {
        return new HelpingArgumentBuilder(literal);
    }

    public HelpingArgumentBuilder requires(Predicate<CommandSourceStack> requirement) {
        this.requirement = requirement;
        return this;
    }

    public Predicate<CommandSourceStack> getRequirement() {
        if (this.requirement != null) {
            return this.requirement;
        }
        List<Predicate> requirements = Stream.concat(this.children.stream().map(ArgumentBuilder::getRequirement), this.getArguments().stream().map(CommandNode::getRequirement)).toList();
        return x -> requirements.stream().anyMatch(y -> y.test(x));
    }

    public LiteralArgumentBuilder<CommandSourceStack> executes(Command<CommandSourceStack> command) {
        throw new IllegalStateException("Cannot use executes on a HelpingArgumentBuilder");
    }

    public LiteralArgumentBuilder<CommandSourceStack> then(ArgumentBuilder<CommandSourceStack, ?> argument) {
        if (this.getRedirect() != null) {
            throw new IllegalStateException("Cannot add children to a redirected node");
        }
        if (argument instanceof HelpingArgumentBuilder) {
            this.children.add((HelpingArgumentBuilder)argument);
        } else if (argument instanceof LiteralArgumentBuilder) {
            super.then(argument);
        } else {
            throw new IllegalStateException("HelpingArgumentBuilder can only accept literal children");
        }
        return this;
    }

    public LiteralArgumentBuilder<CommandSourceStack> then(CommandNode<CommandSourceStack> argument) {
        if (!(argument instanceof LiteralCommandNode)) {
            throw new IllegalStateException("HelpingArgumentBuilder can only accept literal children");
        }
        return (LiteralArgumentBuilder)super.then(argument);
    }

    public LiteralCommandNode<CommandSourceStack> build() {
        return this.buildImpl(this.getLiteral().replace('-', '_'), this.getLiteral());
    }

    private LiteralCommandNode<CommandSourceStack> build(String id, String command) {
        return this.buildImpl(id + "." + this.getLiteral().replace('-', '_'), command + " " + this.getLiteral());
    }

    private LiteralCommandNode<CommandSourceStack> buildImpl(String id, String command) {
        LiteralCommandNode node;
        HelpCommand helpCommand = new HelpCommand(id, command);
        helpCommand.node = node = new LiteralCommandNode(this.getLiteral(), (Command)helpCommand, this.getRequirement(), this.getRedirect(), this.getRedirectModifier(), this.isFork());
        LiteralArgumentBuilder helpNode = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").executes((Command)helpCommand);
        for (CommandNode child : this.getArguments()) {
            node.addChild(child);
            helpNode.then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)child.getName()).requires(child.getRequirement())).executes(HelpingArgumentBuilder.helpForChild((CommandNode<CommandSourceStack>)child, id, command))).build());
        }
        for (HelpingArgumentBuilder childBuilder : this.children) {
            LiteralCommandNode<CommandSourceStack> child = childBuilder.build(id, command);
            node.addChild(child);
            helpNode.then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)child.getName()).requires(child.getRequirement())).executes(HelpingArgumentBuilder.helpForChild(child, id, command))).redirect(child.getChild("help"))).build());
        }
        node.addChild((CommandNode)helpNode.build());
        return node;
    }

    private static Command<CommandSourceStack> helpForChild(CommandNode<CommandSourceStack> node, String id, String command) {
        return context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> HelpingArgumentBuilder.getHelp((CommandContext<CommandSourceStack>)context, node, id + "." + node.getName().replace('-', '_'), command + " " + node.getName()), false);
            return 0;
        };
    }

    private static Component getHelp(CommandContext<CommandSourceStack> context, CommandNode<CommandSourceStack> node, String id, String command) {
        CommandDispatcher dispatcher = ((CommandSourceStack)context.getSource()).getServer().getCommands().getDispatcher();
        LiteralCommandNode temp = new LiteralCommandNode("_", null, x -> true, null, null, false);
        temp.addChild(node);
        String usage = Nullability.assertNonNull((String)dispatcher.getSmartUsage((CommandNode)temp, (Object)((CommandSourceStack)context.getSource())).get(node)).substring(node.getName().length());
        MutableComponent output = Component.literal((String)"").append((Component)ChatHelpers.coloured("/" + command + usage, HEADER)).append(" ").append((Component)Component.translatable((String)("commands." + id + ".synopsis")).withStyle(SYNOPSIS)).append("\n").append((Component)Component.translatable((String)("commands." + id + ".desc")));
        for (CommandNode child : node.getChildren()) {
            if (!child.canUse((Object)((CommandSourceStack)context.getSource())) || !(child instanceof LiteralCommandNode)) continue;
            output.append("\n");
            MutableComponent component = ChatHelpers.coloured(child.getName(), NAME);
            component.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + command + " " + child.getName()));
            output.append((Component)component);
            output.append(" - ").append((Component)Component.translatable((String)("commands." + id + "." + child.getName() + ".synopsis")));
        }
        return output;
    }

    private static final class HelpCommand
    implements Command<CommandSourceStack> {
        private final String id;
        private final String command;
        @Nullable LiteralCommandNode<CommandSourceStack> node;

        private HelpCommand(String id, String command) {
            this.id = id;
            this.command = command;
        }

        public int run(CommandContext<CommandSourceStack> context) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> HelpingArgumentBuilder.getHelp(context, (CommandNode<CommandSourceStack>)((CommandNode)Nullability.assertNonNull(this.node)), this.id, this.command), false);
            return 0;
        }
    }
}

