/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public final class LuaValues {
    private LuaValues() {
    }

    public static ByteBuffer encode(String string) {
        byte[] chars = new byte[string.length()];
        for (int i = 0; i < chars.length; ++i) {
            char c = string.charAt(i);
            chars[i] = c < '\u0100' ? (int)c : 63;
        }
        return ByteBuffer.wrap(chars).asReadOnlyBuffer();
    }

    public static String getNumericType(double value) {
        if (Double.isNaN(value)) {
            return "nan";
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "inf";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        return "number";
    }

    public static String getType(@Nullable Object value) {
        if (value == null) {
            return "nil";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Map) {
            return "table";
        }
        return "userdata";
    }

    public static LuaException badArgumentOf(IArguments arguments, int index, String expected) {
        return LuaValues.badArgument(index, expected, arguments.getType(index));
    }

    public static LuaException badArgument(int index, String expected, String actual) {
        return new LuaException("bad argument #" + (index + 1) + " (" + expected + " expected, got " + actual + ")");
    }

    public static LuaException badTableItem(int index, String expected, String actual) {
        return new LuaException("table item #" + index + " is not " + expected + " (got " + actual + ")");
    }

    public static LuaException badField(String key, String expected, String actual) {
        return new LuaException("field " + key + " is not " + expected + " (got " + actual + ")");
    }

    public static Number checkFiniteNum(int index, Number value) throws LuaException {
        LuaValues.checkFinite(index, value.doubleValue());
        return value;
    }

    public static double checkFinite(int index, double value) throws LuaException {
        if (!Double.isFinite(value)) {
            throw LuaValues.badArgument(index, "number", LuaValues.getNumericType(value));
        }
        return value;
    }

    public static <T extends Enum<T>> T checkEnum(int index, Class<T> klass, String value) throws LuaException {
        for (Enum possibility : (Enum[])klass.getEnumConstants()) {
            if (!possibility.name().equalsIgnoreCase(value)) continue;
            return (T)possibility;
        }
        throw new LuaException("bad argument #" + (index + 1) + " (unknown option " + value + ")");
    }
}

